/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.preferences;

import com.aptana.ide.syncing.ui.preferences.IPreferenceConstants;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class SyncPreferenceUtil {
    public static boolean isAutoSync(IProject project) {
        return Platform.getPreferencesService().getBoolean("com.aptana.syncing.ui", MessageFormat.format("{0}:{1}", "AutoSyncChangesWithRemote", project.getName()), false, null);
    }

    public static IPreferenceConstants.SyncDirection getAutoSyncDirection(IProject project) {
        String type = Platform.getPreferencesService().getString("com.aptana.syncing.ui", MessageFormat.format("{0}:{1}", "AutoSyncDirection", project.getName()), null, null);
        if (type != null) {
            if (type.equals(IPreferenceConstants.SyncDirection.UPLOAD.toString())) {
                return IPreferenceConstants.SyncDirection.UPLOAD;
            }
            if (type.equals(IPreferenceConstants.SyncDirection.DOWNLOAD.toString())) {
                return IPreferenceConstants.SyncDirection.DOWNLOAD;
            }
            if (type.equals(IPreferenceConstants.SyncDirection.BOTH.toString())) {
                return IPreferenceConstants.SyncDirection.BOTH;
            }
        }
        return null;
    }

    public static void setAutoSync(IProject project, boolean autoSync) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.syncing.ui");
        prefs.putBoolean(MessageFormat.format("{0}:{1}", "AutoSyncChangesWithRemote", project.getName()), autoSync);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void setAutoSyncDirection(IProject project, IPreferenceConstants.SyncDirection direction) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.syncing.ui");
        prefs.put(MessageFormat.format("{0}:{1}", "AutoSyncDirection", project.getName()), direction.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }
}

